// ============================================================
// NAVTCC SEO Tool — Live HTML Preview Builder
// Created by Jawad with help of AI
// ============================================================

function buildPreview(biz, theme, content) {
    const c      = content || {};
    const mapQ   = encQ(`${biz.address} ${biz.city} Pakistan`);
    const heroImg= `https://source.unsplash.com/1200x600/?${encQ(biz.type)},professional`;
    const aboutImg=`https://source.unsplash.com/800x500/?${encQ(biz.type + ' team')}`;

    const svcEmojis = ['⭐','✅','⚙️','❤️','🏆','🛡️','⚡','💎','🎯','🌟'];

    return `<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>${esc(biz.metaTitle_home)}</title>
<meta name="description" content="${esc(biz.metaDesc_home)}">
<link href="https://fonts.googleapis.com/css2?family=${theme.gfonts}&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0}
body{font-family:${theme.bodyFont};color:${theme.text};background:${theme.bg};line-height:1.65}
a{text-decoration:none;color:inherit}
nav{background:${theme.primary};padding:0 40px;display:flex;align-items:center;justify-content:space-between;height:68px;position:sticky;top:0;z-index:99}
.logo{color:#fff;font-family:${theme.font};font-size:1.2rem;font-weight:700}
.nav-links a{color:rgba(255,255,255,0.8);margin-left:28px;font-size:14px;font-weight:500}
.nav-links a:hover{color:${theme.accent}}
.hero{min-height:88vh;background:${theme.heroGrad};display:flex;align-items:center;justify-content:center;text-align:center;padding:60px 20px;position:relative;overflow:hidden}
.hero::before{content:'';position:absolute;inset:0;background:url('${heroImg}') center/cover;opacity:0.14;z-index:0}
.hero-inner{position:relative;z-index:1;max-width:780px}
.hero h1{font-family:${theme.font};font-size:clamp(1.9rem,5vw,3.2rem);color:#fff;margin-bottom:16px;line-height:1.15}
.hero p{font-size:1.1rem;color:rgba(255,255,255,0.88);margin-bottom:32px}
.hero-btns{display:flex;gap:12px;justify-content:center;flex-wrap:wrap}
.btn{display:inline-block;padding:13px 30px;font-weight:700;font-size:14px;transition:transform 0.2s;${theme.btnExtra}}
.btn-p{background:${theme.accent};color:#fff;border-radius:${theme.btnRadius};box-shadow:0 4px 18px ${theme.accent}55}
.btn-p:hover{transform:translateY(-2px)}
.btn-o{background:transparent;color:#fff;border:2px solid rgba(255,255,255,0.7);border-radius:${theme.btnRadius}}
.btn-o:hover{background:rgba(255,255,255,0.1)}
section{padding:80px 20px}
.container{max-width:1080px;margin:0 auto}
.sec-title{font-family:${theme.font};font-size:clamp(1.5rem,3vw,2.2rem);color:${theme.primary};margin-bottom:12px;line-height:1.2}
.sec-sub{color:#64748b;margin-bottom:40px;font-size:1rem;text-align:center}
.card-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:22px}
.card{background:${theme.cardBg};border-radius:12px;padding:28px;box-shadow:0 2px 16px rgba(0,0,0,0.07);transition:transform 0.2s,box-shadow 0.2s;border-top:3px solid ${theme.accent}}
.card:hover{transform:translateY(-4px);box-shadow:0 8px 28px rgba(0,0,0,0.1)}
.card-icon{font-size:2rem;margin-bottom:12px}
.card-title{font-weight:700;font-size:1.05rem;color:${theme.primary};margin-bottom:7px}
.card-desc{color:#64748b;font-size:0.9rem;line-height:1.6}
.svc-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:16px}
.svc-card{background:${theme.cardBg};border-radius:10px;padding:22px;text-align:center;box-shadow:0 2px 12px rgba(0,0,0,0.06);transition:transform 0.2s}
.svc-card:hover{transform:translateY(-3px)}
.svc-icon{font-size:1.8rem;margin-bottom:10px}
.svc-name{font-weight:700;color:${theme.primary};font-size:0.95rem;margin-bottom:5px}
.svc-desc{font-size:0.82rem;color:#64748b}
.about-grid{display:grid;grid-template-columns:1fr 1fr;gap:44px;align-items:center}
@media(max-width:700px){.about-grid{grid-template-columns:1fr}}
.about-grid img{width:100%;border-radius:12px;box-shadow:0 8px 24px rgba(0,0,0,0.1)}
.about-list{list-style:none;margin-top:14px}
.about-list li{padding:7px 0;color:#475569;display:flex;gap:8px;font-size:0.93rem}
.about-list li::before{content:'✓';color:${theme.accent};font-weight:900;flex-shrink:0}
.testi-strip{background:#1e293b;padding:64px 20px;text-align:center}
.testi-grid{display:grid;grid-template-columns:1fr 1fr;gap:20px;max-width:700px;margin:28px auto 0}
@media(max-width:580px){.testi-grid{grid-template-columns:1fr}}
.testi-card{background:rgba(255,255,255,0.06);border-left:3px solid ${theme.accent};border-radius:8px;padding:18px;color:rgba(255,255,255,0.82);font-style:italic;font-size:14px;text-align:left;line-height:1.7}
.testi-author{color:${theme.accent};font-size:12px;font-style:normal;font-weight:700;margin-top:10px;display:block}
.cta-strip{background:${theme.heroGrad};padding:72px 20px;text-align:center}
.cta-strip h2{font-family:${theme.font};color:#fff;font-size:clamp(1.5rem,3vw,2rem);margin-bottom:12px}
.cta-strip p{color:rgba(255,255,255,0.88);margin-bottom:28px}
.cta-btns{display:flex;gap:12px;justify-content:center;flex-wrap:wrap}
footer{background:${theme.primary};color:rgba(255,255,255,0.7);padding:48px 20px 24px;text-align:center}
.footer-name{font-family:${theme.font};color:#fff;font-size:1.3rem;font-weight:700;margin-bottom:8px}
.footer-nap{font-size:13px;margin-bottom:14px;line-height:2.2}
.footer-links a{color:rgba(255,255,255,0.55);margin:0 10px;font-size:13px}
.footer-links a:hover{color:${theme.accent}}
.footer-copy{margin-top:18px;font-size:11px;color:rgba(255,255,255,0.3);border-top:1px solid rgba(255,255,255,0.08);padding-top:16px}
@media(max-width:680px){.nav-links{display:none}}
</style>
</head>
<body>
<nav>
    <div class="logo">${esc(biz.name)}</div>
    <div class="nav-links">
        <a href="#">Home</a><a href="#">Services</a><a href="#">Contact</a>
    </div>
</nav>

<section class="hero">
    <div class="hero-inner">
        <h1>${esc(c.hero_headline || biz.focusKeyword + ' | ' + biz.name)}</h1>
        <p>${esc(c.hero_subheadline || biz.tagline)}</p>
        <div class="hero-btns">
            <a href="#services" class="btn btn-p">${esc(c.hero_cta1 || 'Our Services')}</a>
            <a href="#contact" class="btn btn-o">${esc(c.hero_cta2 || 'Contact Us')}</a>
        </div>
    </div>
</section>

<section style="background:${theme.cardBg}">
    <div class="container" style="text-align:center">
        <h2 class="sec-title">${esc(c.why_us_heading || 'Why Choose ' + biz.name + '?')}</h2>
        <div class="card-grid" style="max-width:860px;margin:0 auto">
            ${(c.why_us_points || [
                { title: `Top Rated ${biz.type}`, desc: `Trusted by customers across ${biz.city}` },
                { title: 'Quality Guaranteed',    desc: 'Professional results every time' },
                { title: 'Always Available',       desc: biz.hours || 'Mon-Sat 9AM-6PM' }
            ]).map((p,i) => `<div class="card"><div class="card-icon">${svcEmojis[i%svcEmojis.length]}</div><div class="card-title">${esc(p.title)}</div><div class="card-desc">${esc(p.desc)}</div></div>`).join('')}
        </div>
    </div>
</section>

<section id="services" style="background:${theme.bg}">
    <div class="container" style="text-align:center">
        <h2 class="sec-title">${esc(c.services_heading || 'Our Services in ' + biz.city)}</h2>
        <p class="sec-sub">${esc(c.services_intro || biz.name + ' — ' + biz.services.join(' • '))}</p>
        <div class="svc-grid">
            ${(c.service_details || biz.services.map(s=>({name:s,desc:`Professional ${s} in ${biz.city}`}))).map((s,i)=>
                `<div class="svc-card"><div class="svc-icon">${svcEmojis[i%svcEmojis.length]}</div><div class="svc-name">${esc(s.name)} in ${esc(biz.city)}</div><div class="svc-desc">${esc(s.desc)}</div></div>`
            ).join('')}
        </div>
    </div>
</section>

<section style="background:${theme.cardBg}">
    <div class="container">
        <div class="about-grid">
            <div>
                <h2 class="sec-title" style="text-align:left">${esc(c.about_heading || 'Best ' + biz.type + ' in ' + biz.city)}</h2>
                <div style="color:#475569;margin-bottom:14px;font-size:0.95rem;line-height:1.7">${c.about_body || `<p>${esc(biz.about || biz.name + ' is a leading ' + biz.type.toLowerCase() + ' in ' + biz.city + '. ' + biz.tagline + '.')}</p>`}</div>
                <ul class="about-list">
                    ${(c.about_points || biz.keywords.map(k=>`Expert ${k}`)).map(p=>`<li>${esc(p)}</li>`).join('')}
                    <li>Conveniently located in ${esc(biz.city)}</li>
                </ul>
            </div>
            <img src="${aboutImg}" alt="${esc(biz.name)} — ${esc(biz.type)} in ${esc(biz.city)}" loading="lazy">
        </div>
    </div>
</section>

<div class="testi-strip">
    <h2 style="font-family:${theme.font};color:#fff;font-size:1.8rem">Trusted by ${esc(biz.city)} Customers</h2>
    <div class="testi-grid">
        <div class="testi-card">"${esc(c.testimonial_1 || 'Best ' + biz.type.toLowerCase() + ' in ' + biz.city + '! Professional team.')}"<span class="testi-author">— Happy Customer, ${esc(biz.city)}</span></div>
        <div class="testi-card">"${esc(c.testimonial_2 || 'Found ' + biz.name + ' while searching for ' + biz.focusKeyword + ' — best decision.')}"<span class="testi-author">— Satisfied Client, ${esc(biz.city)}</span></div>
    </div>
</div>

<div class="cta-strip">
    <h2>${esc(c.cta_heading || 'Contact ' + biz.name + ' Today')}</h2>
    <p>${esc(c.cta_body || biz.tagline)}</p>
    <div class="cta-btns">
        <a href="tel:${esc(biz.phone)}" class="btn btn-p">📞 ${esc(biz.phone)}</a>
        <a href="mailto:${esc(biz.email)}" class="btn btn-o">✉ ${esc(biz.email)}</a>
    </div>
</div>

<section id="contact" style="background:${theme.bg}">
    <div class="container" style="text-align:center">
        <h2 class="sec-title">${esc(c.contact_heading || 'Contact ' + biz.name + ' in ' + biz.city)}</h2>
        <p class="sec-sub">${esc(c.contact_intro || 'We reply within 24 hours')}</p>
        <div class="card-grid" style="max-width:700px;margin:0 auto 40px">
            <div class="card"><div class="card-icon">📍</div><div class="card-title">Address</div><div class="card-desc">${esc(biz.address)}</div></div>
            <div class="card"><div class="card-icon">📞</div><div class="card-title">Phone</div><div class="card-desc">${esc(biz.phone)}</div></div>
            <div class="card"><div class="card-icon">✉</div><div class="card-title">Email</div><div class="card-desc">${esc(biz.email)}</div></div>
        </div>
        <iframe src="https://maps.google.com/maps?q=${mapQ}&output=embed" width="100%" height="340" frameborder="0" style="border:0;border-radius:12px;max-width:820px;display:block;margin:0 auto" allowfullscreen loading="lazy"></iframe>
    </div>
</section>

<footer>
    <div class="footer-name">${esc(biz.name)}</div>
    <div class="footer-nap">📍 ${esc(biz.address)}<br>📞 ${esc(biz.phone)} &nbsp;|&nbsp; ✉ ${esc(biz.email)}</div>
    <div class="footer-links"><a href="#">Home</a><a href="#">Services</a><a href="#">Contact</a></div>
    <div class="footer-copy">© ${new Date().getFullYear()} ${esc(biz.name)}. All rights reserved. ${esc(biz.city)}, Pakistan</div>
</footer>
<script type="application/ld+json">
{"@context":"https://schema.org","@type":"${biz.schemaType||'LocalBusiness'}","name":"${biz.name}","telephone":"${biz.phone}","email":"${biz.email}","address":{"@type":"PostalAddress","streetAddress":"${biz.address}","addressLocality":"${biz.city}","addressCountry":"PK"},"openingHours":"${biz.hours}"}
<\/script>
</body>
</html>`;
}
