// ============================================================
// NAVTCC SEO Tool — Design Randomizer
// Created by Jawad with help of AI
// ============================================================

const PALETTES = [
    { name:'Navy Gold',      primary:'#1a1f4e', accent:'#c9a84c', bg:'#f8f7f4', cardBg:'#ffffff', text:'#1a1f4e', heroGrad:'linear-gradient(135deg,#1a1f4e,#2d3480)' },
    { name:'Emerald White',  primary:'#065f46', accent:'#10b981', bg:'#f0fdf4', cardBg:'#ffffff', text:'#064e3b', heroGrad:'linear-gradient(135deg,#065f46,#059669)' },
    { name:'Deep Purple',    primary:'#4c1d95', accent:'#f43f5e', bg:'#faf5ff', cardBg:'#ffffff', text:'#3b0764', heroGrad:'linear-gradient(135deg,#4c1d95,#6d28d9)' },
    { name:'Royal Indigo',   primary:'#3730a3', accent:'#f59e0b', bg:'#eef2ff', cardBg:'#ffffff', text:'#1e1b4b', heroGrad:'linear-gradient(135deg,#3730a3,#4f46e5)' },
    { name:'Teal Sand',      primary:'#0f766e', accent:'#f97316', bg:'#f0fdfa', cardBg:'#ffffff', text:'#134e4a', heroGrad:'linear-gradient(135deg,#0f766e,#0d9488)' },
    { name:'Crimson Dark',   primary:'#881337', accent:'#e11d48', bg:'#fff1f2', cardBg:'#ffffff', text:'#4c0519', heroGrad:'linear-gradient(135deg,#881337,#be123c)' },
    { name:'Charcoal Amber', primary:'#1c1917', accent:'#f59e0b', bg:'#fafaf9', cardBg:'#ffffff', text:'#1c1917', heroGrad:'linear-gradient(135deg,#292524,#44403c)' },
    { name:'Ocean Blue',     primary:'#1e3a5f', accent:'#06b6d4', bg:'#f0f9ff', cardBg:'#ffffff', text:'#0c2340', heroGrad:'linear-gradient(135deg,#1e3a5f,#1d4ed8)' },
    { name:'Forest Green',   primary:'#14532d', accent:'#84cc16', bg:'#f7fee7', cardBg:'#ffffff', text:'#052e16', heroGrad:'linear-gradient(135deg,#14532d,#166534)' },
    { name:'Violet Coral',   primary:'#5b21b6', accent:'#fb7185', bg:'#faf5ff', cardBg:'#ffffff', text:'#3b0764', heroGrad:'linear-gradient(135deg,#5b21b6,#7c3aed)' },
    { name:'Slate Orange',   primary:'#0f172a', accent:'#f97316', bg:'#f8fafc', cardBg:'#ffffff', text:'#0f172a', heroGrad:'linear-gradient(135deg,#0f172a,#1e293b)' },
    { name:'Rose Gold',      primary:'#9f1239', accent:'#d97706', bg:'#fff1f2', cardBg:'#ffffff', text:'#4c0519', heroGrad:'linear-gradient(135deg,#9f1239,#e11d48)' },
    { name:'Midnight Teal',  primary:'#042f2e', accent:'#2dd4bf', bg:'#f0fdfa', cardBg:'#ffffff', text:'#042f2e', heroGrad:'linear-gradient(135deg,#042f2e,#134e4a)' },
    { name:'Bold Fuchsia',   primary:'#701a75', accent:'#a21caf', bg:'#fdf4ff', cardBg:'#ffffff', text:'#3b0764', heroGrad:'linear-gradient(135deg,#701a75,#a21caf)' },
    { name:'Earth Brown',    primary:'#431407', accent:'#059669', bg:'#fffbeb', cardBg:'#ffffff', text:'#431407', heroGrad:'linear-gradient(135deg,#78350f,#b45309)' },
    { name:'Sky White',      primary:'#075985', accent:'#0ea5e9', bg:'#f0f9ff', cardBg:'#ffffff', text:'#0c4a6e', heroGrad:'linear-gradient(135deg,#075985,#0369a1)' },
    { name:'Dark Lime',      primary:'#1a2e05', accent:'#65a30d', bg:'#f7fee7', cardBg:'#ffffff', text:'#1a2e05', heroGrad:'linear-gradient(135deg,#1a2e05,#365314)' },
    { name:'Warm Plum',      primary:'#2e1065', accent:'#e879f9', bg:'#fdf4ff', cardBg:'#ffffff', text:'#2e1065', heroGrad:'linear-gradient(135deg,#2e1065,#4a1d96)' },
    { name:'Brick Red',      primary:'#7f1d1d', accent:'#f97316', bg:'#fff7ed', cardBg:'#ffffff', text:'#450a0a', heroGrad:'linear-gradient(135deg,#7f1d1d,#991b1b)' },
    { name:'Steel Blue',     primary:'#172554', accent:'#38bdf8', bg:'#eff6ff', cardBg:'#ffffff', text:'#172554', heroGrad:'linear-gradient(135deg,#172554,#1e3a8a)' },
];

const FONT_COMBOS = [
    { head:"'Playfair Display', serif",  body:"'DM Sans', sans-serif",    gfonts:'Playfair+Display:wght@700;900&family=DM+Sans:wght@400;500;700' },
    { head:"'Syne', sans-serif",         body:"'Outfit', sans-serif",      gfonts:'Syne:wght@700;800;900&family=Outfit:wght@400;500;700' },
    { head:"'Fraunces', serif",          body:"'Jost', sans-serif",        gfonts:'Fraunces:wght@700;900&family=Jost:wght@400;500;600' },
    { head:"'Raleway', sans-serif",      body:"'Lato', sans-serif",        gfonts:'Raleway:wght@700;800;900&family=Lato:wght@400;700' },
    { head:"'Oswald', sans-serif",       body:"'Source+Sans+3', sans-serif", gfonts:'Oswald:wght@600;700&family=Source+Sans+3:wght@400;600' },
    { head:"'Libre Baskerville', serif", body:"'Open Sans', sans-serif",   gfonts:'Libre+Baskerville:wght@700&family=Open+Sans:wght@400;600' },
    { head:"'Cormorant', serif",         body:"'Nunito', sans-serif",      gfonts:'Cormorant:wght@600;700&family=Nunito:wght@400;600;700' },
    { head:"'Bebas Neue', sans-serif",   body:"'Mulish', sans-serif",      gfonts:'Bebas+Neue&family=Mulish:wght@400;600;700' },
    { head:"'Cinzel', serif",            body:"'Raleway', sans-serif",     gfonts:'Cinzel:wght@700;900&family=Raleway:wght@400;500;600' },
    { head:"'Montserrat', sans-serif",   body:"'Merriweather', serif",     gfonts:'Montserrat:wght@700;800;900&family=Merriweather:wght@400;700' },
];

const HERO_LAYOUTS = [
    'centered',      // centered text overlay on full image
    'split-left',    // text left, image right
    'split-right',   // image left, text right
    'minimal',       // no image, gradient only
    'overlay-bottom' // image top, text bottom overlay
];

const CARD_STYLES = [
    'border-top',   // colored top border
    'shadow-hover', // shadow + lift on hover
    'outlined',     // just border, clean
    'filled',       // light filled background
    'icon-left',    // icon on left, text right
    'gradient-bg',  // subtle gradient background
];

const BUTTON_STYLES = [
    { radius:'4px',  extra:'text-transform:uppercase;letter-spacing:2px;font-size:13px;' },
    { radius:'50px', extra:'font-weight:800;' },
    { radius:'8px',  extra:'font-weight:700;' },
    { radius:'2px',  extra:'letter-spacing:1px;font-weight:700;' },
    { radius:'12px', extra:'font-weight:600;' },
    { radius:'0px',  extra:'text-transform:uppercase;letter-spacing:3px;font-size:11px;font-weight:800;border-bottom:3px solid;' },
];

const DIVIDERS = [
    '',  // none
    '<div style="overflow:hidden;line-height:0;margin-top:-2px"><svg viewBox="0 0 1440 60" xmlns="http://www.w3.org/2000/svg"><path d="M0,30 C360,60 1080,0 1440,30 L1440,60 L0,60 Z" fill="__BG__"/></svg></div>',
    '<div style="overflow:hidden;line-height:0;margin-top:-2px"><svg viewBox="0 0 1440 60" xmlns="http://www.w3.org/2000/svg"><path d="M0,60 L720,0 L1440,60 Z" fill="__BG__"/></svg></div>',
    '<div style="overflow:hidden;line-height:0;margin-top:-2px"><svg viewBox="0 0 1440 60" xmlns="http://www.w3.org/2000/svg"><path d="M0,0 Q720,60 1440,0 L1440,60 L0,60 Z" fill="__BG__"/></svg></div>',
    '<div style="height:4px;background:linear-gradient(90deg,__ACCENT__,transparent)"></div>',
];

const NAV_STYLES = [
    'simple',    // logo left, links right
    'centered',  // centered logo, links below
    'dark-bar',  // dark background always
    'transparent'// transparent on hero
];

// ── Random picker ────────────────────────────────────────────
const rnd = arr => arr[Math.floor(Math.random() * arr.length)];

function getRandomDesign() {
    return {
        palette:    rnd(PALETTES),
        fonts:      rnd(FONT_COMBOS),
        heroLayout: rnd(HERO_LAYOUTS),
        cardStyle:  rnd(CARD_STYLES),
        btnStyle:   rnd(BUTTON_STYLES),
        divider:    rnd(DIVIDERS),
        navStyle:   rnd(NAV_STYLES),
    };
}

// ── Apply design to Elementor theme ─────────────────────────
function designToTheme(design) {
    const p = design.palette;
    return {
        primary:    p.primary,
        accent:     p.accent,
        bg:         p.bg,
        cardBg:     p.cardBg,
        text:       p.text,
        heroGrad:   p.heroGrad,
        font:       design.fonts.head,
        bodyFont:   design.fonts.body,
        gfonts:     design.fonts.gfonts,
        btnRadius:  design.btnStyle.radius,
        btnExtra:   design.btnStyle.extra,
        heroLayout: design.heroLayout,
        cardStyle:  design.cardStyle,
        paletteName:p.name,
    };
}
