// ============================================================
// NAVTCC SEO Tool — Main Application
// Created by Jawad with help of AI
// ============================================================

// ── State ────────────────────────────────────────────────────
let selectedTheme   = 'corporate';
let currentKeyTab   = 'groq';
let currentBiz      = null;
let currentContent  = null;
let currentPages    = null;
let currentTheme    = null;
let currentDesign   = null;
let currentAiUsed   = false;
let currentProvider = '';
let seoResult       = null;
let kwData          = [];

// ── Helpers ──────────────────────────────────────────────────
function esc(s) {
    return String(s || '')
        .replace(/&/g,'&amp;').replace(/</g,'&lt;')
        .replace(/>/g,'&gt;').replace(/"/g,'&quot;');
}
function slugify(s) {
    return String(s||'').toLowerCase().replace(/[^a-z0-9]+/g,'-').replace(/^-|-$/g,'');
}
function copyText(text, btnId) {
    navigator.clipboard.writeText(text).then(() => {
        const btn = document.getElementById(btnId);
        if (!btn) return;
        const orig = btn.textContent;
        btn.textContent = '✓ Copied!'; btn.classList.add('copied');
        setTimeout(() => { btn.textContent = orig; btn.classList.remove('copied'); }, 2000);
    }).catch(() => alert('Copy failed.'));
}
function downloadFile(content, filename, type = 'application/json') {
    const blob = new Blob([content], { type });
    const url  = URL.createObjectURL(blob);
    const a    = document.createElement('a');
    a.href = url; a.download = filename; a.click();
    URL.revokeObjectURL(url);
}
function showError(msg) {
    const b = document.getElementById('errorBox');
    b.textContent = '⚠ ' + msg; b.style.display = 'block';
    window.scrollTo({ top: b.offsetTop - 20, behavior: 'smooth' });
    setTimeout(() => b.style.display = 'none', 8000);
}
function setLoading(on, msg) {
    document.getElementById('loadingBar').style.display = on ? 'block' : 'none';
    document.getElementById('btnGen').disabled = on;
    document.getElementById('btnGen').textContent = on
        ? '⏳ Generating...' : '⚡ Generate 3 Elementor Pages with AI';
    const gs = document.getElementById('genStatus');
    if (gs) { gs.style.display = on ? 'block' : 'none'; gs.textContent = msg || ''; }
}

// ── Key Management ────────────────────────────────────────────
function saveProviderKey(tab, val) {
    const tabCfg = KEY_TABS[tab];
    if (!tabCfg || !val || val.length < 10) return;
    localStorage.setItem(tabCfg.storage, val.trim());
    document.getElementById('keySavedNote').style.display = 'block';
    renderProviderStatus();
}
function loadSaved() {
    const code = localStorage.getItem('navtcc_code');
    if (code) {
        document.getElementById('classCode').value = code;
        saveClassCode(code);
    }
    // Load all saved keys into inputs
    for (const [tab, cfg] of Object.entries(KEY_TABS)) {
        const key = localStorage.getItem(cfg.storage);
        const inp = document.getElementById('apiKey' + tab.charAt(0).toUpperCase() + tab.slice(1));
        if (inp && key) inp.value = key;
    }
    renderProviderStatus();
}
function saveClassCode(val) {
    if (val) localStorage.setItem('navtcc_code', val);
    const validCode = document.getElementById('classCode').dataset.valid || '';
    const ok  = val === validCode || localStorage.getItem('navtcc_code') === validCode;
    const el  = document.getElementById('codeStatus');
    el.textContent = ok ? '✓ Unlocked' : '';
    el.style.color = 'var(--green)';
}

// ── Provider Status Bar ───────────────────────────────────────
function renderProviderStatus() {
    const grid   = document.getElementById('psbGrid');
    if (!grid) return;
    const status = router.getStatus();
    grid.innerHTML = Object.entries(status).map(([id, s]) => {
        const dotClass = s.status === 'ready' ? 'ready'
                       : s.status === 'no-key' ? 'no-key'
                       : s.status.startsWith('rate-limit') ? 'rate-limit'
                       : 'exhausted';
        const labelTxt = s.status === 'ready'   ? `${100 - s.pct}% quota left`
                       : s.status === 'no-key'  ? 'No key added'
                       : s.status.startsWith('rate-limit') ? `Cooldown ${s.status.split(':')[1]}s`
                       : s.status === 'exhausted' ? 'Daily limit reached'
                       : 'Errors — retrying';
        const barColor = dotClass === 'ready' ? 'var(--green)' : dotClass === 'rate-limit' ? 'var(--amber)' : 'var(--red)';
        return `<div class="psb-item">
            <div class="psb-top">
                <div class="psb-dot ${dotClass}"></div>
                <div class="psb-name">${s.emoji} ${s.name}</div>
            </div>
            <div class="psb-bar-bg"><div class="psb-bar" style="width:${100-s.pct}%;background:${barColor}"></div></div>
            <div class="psb-label">${labelTxt}</div>
        </div>`;
    }).join('');
}

// ── Tab switching ─────────────────────────────────────────────
function switchKeyTab(tab) {
    currentKeyTab = tab;
    ['groq','gemini','openrouter'].forEach(t => {
        const btn = document.getElementById('tab' + t.charAt(0).toUpperCase() + t.slice(1));
        const ins = document.getElementById('instructions_' + t);
        const inp = document.getElementById('apiKey' + t.charAt(0).toUpperCase() + t.slice(1));
        if (btn) btn.classList.toggle('active', t === tab);
        if (ins) ins.style.display = t === tab ? 'block' : 'none';
        if (inp) inp.style.display = t === tab ? 'block' : 'none';
    });
}
function toggleKeyVisibility() {
    const activeInp = document.getElementById('apiKey' + currentKeyTab.charAt(0).toUpperCase() + currentKeyTab.slice(1));
    const btn = document.querySelector('.api-key-toggle');
    if (!activeInp) return;
    activeInp.type = activeInp.type === 'password' ? 'text' : 'password';
    btn.textContent = activeInp.type === 'password' ? 'Show' : 'Hide';
}

// ── Theme select ──────────────────────────────────────────────
function selectTheme(el, id) {
    document.querySelectorAll('.theme-card').forEach(c => c.classList.remove('active'));
    el.classList.add('active');
    selectedTheme = id;
}
function switchTab(id, el) {
    document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
    document.querySelectorAll('.tab-content').forEach(t => t.classList.remove('active'));
    el.classList.add('active');
    document.getElementById('tab-' + id).classList.add('active');
}
function goBack() {
    document.getElementById('pageResult').classList.remove('active');
    document.getElementById('pageInput').classList.add('active');
    document.getElementById('navBack').style.display = 'none';
    renderProviderStatus();
    window.scrollTo(0, 0);
}
function syncColor(val) {
    if (/^#[0-9a-fA-F]{6}$/.test(val)) document.getElementById('bizColor').value = val;
}
function switchProvider(p) {
    selectedProvider = p;
    document.getElementById('tabGroq').classList.toggle('active', p === 'groq');
    document.getElementById('tabGemini').classList.toggle('active', p === 'gemini');
    document.getElementById('groqInstructions').style.display  = p === 'groq'   ? 'block' : 'none';
    document.getElementById('geminiInstructions').style.display= p === 'gemini' ? 'block' : 'none';
    const ph = p === 'groq'
        ? 'Paste your Groq key here... (starts with gsk_)'
        : 'Paste your Gemini key here... (starts with AIza)';
    document.getElementById('apiKey').placeholder = ph;
    loadProviderKey(p);
}
function toggleKeyVisibility() {
    const inp = document.getElementById('apiKey');
    const btn = document.querySelector('.api-key-toggle');
    if (inp.type === 'password') { inp.type = 'text';     btn.textContent = 'Hide'; }
    else                          { inp.type = 'password'; btn.textContent = 'Show'; }
}
function syncColor(val) {
    if (/^#[0-9a-fA-F]{6}$/.test(val)) document.getElementById('bizColor').value = val;
}
function switchTab(id, el) {
    document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
    document.querySelectorAll('.tab-content').forEach(t => t.classList.remove('active'));
    el.classList.add('active');
    document.getElementById('tab-' + id).classList.add('active');
}
function goBack() {
    document.getElementById('pageResult').classList.remove('active');
    document.getElementById('pageInput').classList.add('active');
    document.getElementById('navBack').style.display = 'none';
    window.scrollTo(0, 0);
}
function loadExample() {
    document.getElementById('bizName').value     = 'Al-Noor Dental Clinic';
    document.getElementById('bizType').value     = 'Dental Clinic';
    document.getElementById('bizServices').value = 'Teeth Whitening, Dental Braces, Root Canal, Dental Implants, Checkup';
    document.getElementById('bizCity').value     = 'Lahore';
    document.getElementById('bizTagline').value  = 'Your Perfect Smile Starts Here';
    document.getElementById('bizKeywords').value = 'best dentist lahore, dental clinic lahore, teeth whitening lahore, affordable dentist lahore';
    document.getElementById('bizPhone').value    = '+92-300-1234567';
    document.getElementById('bizEmail').value    = 'info@alnoor-dental.com';
    document.getElementById('bizAddress').value  = '123 Main Boulevard, Gulberg III, Lahore';
    document.getElementById('bizHours').value    = 'Mon-Sat 9AM-7PM';
    document.getElementById('bizAbout').value    = 'Al-Noor Dental Clinic has been serving Lahore since 2010 with experienced dentists and modern equipment, making quality dental care accessible and affordable for everyone.';
    document.getElementById('bizColor').value    = '#1a56db';
    document.getElementById('bizColorHex').value = '#1a56db';
    selectTheme(document.querySelector('[data-theme="vibrant"]'), 'vibrant');
}

// ── Collect form data ─────────────────────────────────────────
function collectBiz() {
    const name     = document.getElementById('bizName').value.trim();
    const type     = document.getElementById('bizType').value.trim();
    const city     = document.getElementById('bizCity').value.trim();
    const tagline  = document.getElementById('bizTagline').value.trim();
    const phone    = document.getElementById('bizPhone').value.trim();
    const email    = document.getElementById('bizEmail').value.trim();
    const address  = document.getElementById('bizAddress').value.trim();
    const hours    = document.getElementById('bizHours').value.trim() || 'Mon-Sat 9AM-6PM';
    const about    = document.getElementById('bizAbout').value.trim();
    const color    = document.getElementById('bizColor').value || '#6366f1';
    const services = document.getElementById('bizServices').value.split(',').map(s=>s.trim()).filter(Boolean);
    const keywords = document.getElementById('bizKeywords').value.split(',').map(k=>k.trim()).filter(Boolean);

    if (!name || !type || !city || !phone || !email || !address || services.length === 0 || keywords.length === 0) {
        return null;
    }

    const mainKw = keywords[0] || `${type} ${city}`.toLowerCase();

    return {
        name, type, city, tagline, phone, email, address, hours, about, color,
        services, keywords,
        focusKeyword:    mainKw,
        schemaType:      guessSchema(type),
        metaTitle_home:  `${mainKw} | ${name} — ${city}`.substring(0, 60),
        metaDesc_home:   `${name} offers professional ${type.toLowerCase()} in ${city}. ${tagline}. Call ${phone} today.`.substring(0, 160),
        metaTitle_services: `Services | ${name} — Best ${type} in ${city}`.substring(0, 60),
        metaDesc_services:  `Explore ${type.toLowerCase()} services at ${name} in ${city}: ${services.slice(0,3).join(', ')} and more.`.substring(0, 160),
        metaTitle_contact:  `Contact ${name} | ${type} in ${city}`.substring(0, 60),
        metaDesc_contact:   `Contact ${name} — trusted ${type.toLowerCase()} in ${city}. Phone: ${phone}. Email: ${email}.`.substring(0, 160),
        slug_home: '/', slug_services: '/services', slug_contact: '/contact',
    };
}
function guessSchema(type) {
    const t = type.toLowerCase();
    if (t.includes('dent'))                              return 'Dentist';
    if (t.includes('doctor')||t.includes('clinic')||t.includes('hospital')) return 'MedicalClinic';
    if (t.includes('restaurant')||t.includes('cafe')||t.includes('food'))   return 'Restaurant';
    if (t.includes('salon')||t.includes('beauty')||t.includes('spa'))       return 'BeautySalon';
    if (t.includes('law')||t.includes('legal')||t.includes('advocate'))     return 'LegalService';
    if (t.includes('school')||t.includes('academy')||t.includes('education'))return 'EducationalOrganization';
    if (t.includes('gym')||t.includes('fitness'))        return 'ExerciseGym';
    if (t.includes('hotel')||t.includes('guest'))        return 'LodgingBusiness';
    if (t.includes('pharmacy')||t.includes('medical'))   return 'Pharmacy';
    return 'LocalBusiness';
}

// ── System prompt for AI ──────────────────────────────────────
function buildSystemPrompt() {
    return `You are an expert SEO copywriter for Pakistan-based businesses.
Generate unique, natural, keyword-rich content for a 3-page website.
Return ONLY raw JSON — no markdown, no code fences, no explanation.

Required JSON structure:
{
  "business": {
    "name":"","type":"","tagline":"","city":"","phone":"","email":"","address":"","hours":"",
    "keywords":[],"services":[],"schemaType":"","focusKeyword":"",
    "metaTitle_home":"50-60 chars with keyword first",
    "metaDesc_home":"150-160 chars with CTA",
    "metaTitle_services":"50-60 chars",
    "metaDesc_services":"150-160 chars",
    "metaTitle_contact":"50-60 chars",
    "metaDesc_contact":"150-160 chars",
    "slug_home":"/","slug_services":"/services","slug_contact":"/contact"
  },
  "content": {
    "hero_headline":"H1 with keyword + city max 10 words",
    "hero_subheadline":"one compelling sentence",
    "hero_cta1":"3-4 word button text",
    "hero_cta2":"3-4 word button text",
    "about_heading":"H2 with keyword max 8 words",
    "about_body":"3 paragraphs 150-200 words total natural keyword-rich HTML <p> tags",
    "about_points":["point 1","point 2","point 3","point 4","point 5"],
    "why_us_heading":"H2 why choose us in city",
    "why_us_points":[{"title":"","desc":"one sentence with keyword"},{"title":"","desc":""},{"title":"","desc":""},{"title":"","desc":""}],
    "services_heading":"H2 services in city with keyword",
    "services_intro":"2 sentence intro with keyword",
    "service_details":[{"name":"","desc":"3-4 sentences detailed natural description","benefit":"key benefit phrase","price_hint":"affordable / competitive / best rates"}],
    "faq":[{"q":"question with keyword","a":"detailed answer 2-3 sentences"},{"q":"","a":""},{"q":"","a":""}],
    "testimonial_1":"realistic customer review 2 sentences mentioning city and service",
    "testimonial_2":"another realistic review different service angle",
    "testimonial_3":"third review mentioning specific result",
    "cta_heading":"urgency H2 max 8 words",
    "cta_body":"2-3 sentences encouraging contact with benefit",
    "contact_heading":"H1 contact page with city",
    "contact_intro":"2 welcoming sentences",
    "services_page_intro":"3-4 sentences keyword-rich intro for services page",
    "footer_tagline":"5-8 word memorable tagline"
  }
}

RULES:
- Write 1200+ words total across all content fields
- Keywords appear naturally — never stuffed
- Pakistan context — local tone, city-specific
- Each service gets unique detailed description
- FAQ questions should be what customers actually search`;
}

function buildUserPrompt(biz) {
    return `Generate complete SEO content for this business:

Business Name: ${biz.name}
Business Type: ${biz.type}
City: ${biz.city}
Tagline: ${biz.tagline}
Services: ${biz.services.join(', ')}
Target Keywords: ${biz.keywords.join(', ')}
Phone: ${biz.phone}
Email: ${biz.email}
Address: ${biz.address}
Working Hours: ${biz.hours}
About: ${biz.about || 'Write a professional compelling about section'}
Schema Type: ${biz.schemaType}
Focus Keyword: ${biz.focusKeyword}`;
}

// ── Main generate ─────────────────────────────────────────────
async function generate() {
    const biz = collectBiz();
    if (!biz) {
        showError('Please fill in all required fields marked with *');
        return;
    }

    // Validate class code
    const classCode = document.getElementById('classCode').value.trim();
    const validCode = document.getElementById('classCode').dataset.valid || '';
    if (classCode !== validCode) {
        showError('Invalid class code. Ask your instructor for the correct code.');
        return;
    }

    setLoading(true, '🤖 Checking available AI providers...');
    document.getElementById('errorBox').style.display = 'none';

    try {
        let content    = null;
        let mergedBiz  = { ...biz };
        let aiUsed     = false;
        let providerName = '';

        // ── Smart Router call ────────────────────────────────
        const result = await router.call(
            buildSystemPrompt(),
            buildUserPrompt(biz),
            (msg) => setLoading(true, msg)
        );

        if (result) {
            const aiData = result.data;
            if (aiData?.business) mergedBiz = { ...biz, ...aiData.business };
            content      = aiData?.content || null;
            aiUsed       = true;
            providerName = result.provider;
            console.log('✅ AI content from:', result.provider);
        } else {
            console.log('⚠ All providers failed — using JS templates');
        }

        // Get random design
        const design = getRandomDesign();
        const theme  = designToTheme(design);

        // Build pages
        const pages = buildAllPages(mergedBiz, theme, content);

        // SEO analysis
        const allText = pages.home + pages.service + pages.contact;
        seoResult  = calcSEO(mergedBiz);
        kwData     = calcDensity(mergedBiz, allText);

        // Store state
        currentBiz      = mergedBiz;
        currentContent  = content;
        currentPages    = pages;
        currentTheme    = theme;
        currentDesign   = design;
        currentAiUsed   = aiUsed;
        currentProvider = providerName;

        // Render
        renderResults(mergedBiz, theme, pages, seoResult, kwData, content, aiUsed, providerName);

        // Switch page
        document.getElementById('pageInput').classList.remove('active');
        document.getElementById('pageResult').classList.add('active');
        document.getElementById('navBack').style.display = 'block';
        window.scrollTo(0, 0);

    } catch(e) {
        showError('Error: ' + e.message);
    } finally {
        setLoading(false);
        renderProviderStatus();
    }
}

function randomizeDesign() {
    if (!currentBiz || !currentPages) return;
    const design  = getRandomDesign();
    const theme   = designToTheme(design);
    const pages   = buildAllPages(currentBiz, theme, currentContent);
    const allText = pages.home + pages.service + pages.contact;
    currentDesign = design; currentTheme = theme; currentPages = pages;
    kwData = calcDensity(currentBiz, allText);
    renderResults(currentBiz, theme, pages, seoResult, kwData, currentContent, currentAiUsed, currentProvider);
    const btn = document.getElementById('btnRandomize');
    btn.textContent = `🎲 Randomized! Palette: ${design.palette.name}`;
    setTimeout(() => btn.textContent = '🎲 Randomize Design — Same Content, New Look', 2500);
}

function renderResults(biz, theme, pages, seoRes, kws, content, aiUsed, providerName) {
    renderBizHeader(biz, theme, seoRes, aiUsed, providerName);
    renderPreview(biz, theme, content);
    renderTemplates(biz, pages, theme);
    renderSEO(seoRes);
    renderKeywords(kws);
    renderYoast(biz, seoRes);
    renderGMB(biz);
}

function renderBizHeader(biz, theme, seoRes, aiUsed, providerName) {
    const sc      = seoRes.score;
    const scColor = sc >= 80 ? 'var(--green)' : sc >= 60 ? 'var(--amber)' : 'var(--red)';
    const aiBadge = aiUsed
        ? `<span class="badge" style="background:rgba(16,185,129,0.15);color:var(--green);border-color:rgba(16,185,129,0.3)">✨ AI — ${esc(providerName||'AI')}</span>`
        : `<span class="badge" style="background:rgba(245,158,11,0.15);color:var(--amber);border-color:rgba(245,158,11,0.3)">⚡ JS Template Engine</span>`;
    document.getElementById('bizHeader').innerHTML = `
        <div class="biz-icon" style="background:linear-gradient(135deg,${theme.primary},${theme.accent})">${currentDesign?.palette?.name?.slice(0,2)||'⚡'}</div>
        <div style="flex:1">
            <div class="biz-name">${esc(biz.name)}</div>
            <div class="biz-tag">${esc(biz.tagline||'')}</div>
            <div class="badges">
                <span class="badge" style="background:${theme.accent}22;color:${theme.accent};border-color:${theme.accent}44">${esc(biz.type)}</span>
                <span class="badge" style="background:rgba(16,185,129,0.14);color:var(--green);border-color:rgba(16,185,129,0.28)">${esc(biz.city)}</span>
                <span class="badge" style="background:rgba(99,102,241,0.14);color:#a5b4fc;border-color:rgba(99,102,241,0.28)">${esc(currentDesign?.palette?.name||'Custom')}</span>
                <span class="badge" style="background:${scColor}22;color:${scColor};border-color:${scColor}44">SEO ${sc}/100</span>
                ${aiBadge}
            </div>
        </div>`;
}

function renderPreview(biz, theme, content) {
    document.getElementById('previewUrl').textContent = slugify(biz.name) + '.com — Live Preview';
    document.getElementById('previewFrame').srcdoc = buildPreview(biz, theme, content);
}

function renderTemplates(biz, pages, theme) {
    const tpls = [
        { key:'home',    label:'Home Page',     icon:'🏠', color:'var(--green)' },
        { key:'service', label:'Services Page', icon:'⚙️', color:'var(--accent)' },
        { key:'contact', label:'Contact Page',  icon:'📞', color:'var(--amber)' },
    ];
    document.getElementById('templatesContent').innerHTML = tpls.map(t => `
        <div class="tpl-card">
            <div class="tpl-top">
                <div class="tpl-title">
                    <span>${t.icon}</span>
                    <span>${t.label}</span>
                    <span class="badge" style="background:${t.color}22;color:${t.color};border-color:${t.color}44">${t.key.toUpperCase()}</span>
                </div>
                <div class="tpl-actions">
                    <button class="btn-copy" id="copy_${t.key}" onclick="copyJSON('${t.key}')">Copy JSON</button>
                    <button class="btn-dl" onclick="downloadJSON('${t.key}')"
                        style="background:${t.color}22;color:${t.color};border-color:${t.color}44">⬇ Download .json</button>
                </div>
            </div>
            <div class="tpl-preview">${esc((pages[t.key]||'').substring(0, 280))}...</div>
        </div>`).join('');
}

function renderYoast(biz, seoRes) {
    const pages = [
        { label:'🏠 Home Page',     color:'var(--accent)', focus:biz.focusKeyword,        title:biz.metaTitle_home,     desc:biz.metaDesc_home,     slug:biz.slug_home },
        { label:'⚙️ Services Page', color:'var(--green)',  focus:biz.keywords?.[1]||biz.focusKeyword, title:biz.metaTitle_services, desc:biz.metaDesc_services, slug:biz.slug_services },
        { label:'📞 Contact Page',  color:'var(--amber)',  focus:biz.keywords?.[2]||biz.focusKeyword, title:biz.metaTitle_contact,  desc:biz.metaDesc_contact,  slug:biz.slug_contact },
    ];
    document.getElementById('yoastContent').innerHTML = pages.map((yp, i) => `
        <div class="yoast-page">
            <div class="yoast-pg-title" style="color:${yp.color}">${yp.label}</div>
            ${[
                { name:'Focus Keyword',               val: yp.focus,  id:`fk${i}` },
                { name:'SEO Title (50–60 chars)',      val: yp.title,  id:`st${i}` },
                { name:'Meta Description (150–160 ch)',val: yp.desc,   id:`md${i}` },
                { name:'URL Slug',                     val: yp.slug,   id:`sl${i}` },
            ].map(f => `
                <div class="field-row">
                    <div class="field-top">
                        <div class="field-name">${f.name}</div>
                        <div style="display:flex;gap:6px;align-items:center">
                            <span class="char-count" style="color:var(--muted)">${(f.val||'').length} chars</span>
                            <button class="btn-copy" id="${f.id}" onclick="copyText(${JSON.stringify(f.val||'')}, '${f.id}')">Copy</button>
                        </div>
                    </div>
                    <div class="field-val">${esc(f.val || '—')}</div>
                </div>
            `).join('')}
            <div style="margin-top:12px">
                <div style="font-size:10px;color:var(--muted);font-family:var(--font-mono);margin-bottom:8px;letter-spacing:1px">SERP PREVIEW</div>
                <div class="serp-box">
                    <div class="serp-url">yourdomain.com${yp.slug}</div>
                    <div class="serp-title">${esc(yp.title)}</div>
                    <div class="serp-desc">${esc(yp.desc)}</div>
                </div>
            </div>
        </div>`).join('');
}

function renderGMB(biz) {
    const items = [
        `Search "Google My Business" → business.google.com → Create free listing`,
        `Business name exactly: "${biz.name}"`,
        `Category: ${biz.type}`,
        `Address: ${biz.address}`,
        `Phone: ${biz.phone}`,
        `Upload 5+ real photos of your ${biz.type.toLowerCase()}`,
        `Ask every customer to leave a Google Review`,
        `Also list on: Locally.pk, PakistanDirectory.com, OLX.com.pk`,
        `NAP must be identical: website + GMB + all directories`,
    ];
    document.getElementById('gmbBox').innerHTML = `
        <div class="gmb-title">🗺 LOCAL SEO — GOOGLE MY BUSINESS (Pakistan)</div>
        ${items.map(t => `<div class="gmb-item"><span class="gmb-check">☐</span>${esc(t)}</div>`).join('')}`;
}

// ── Copy / Download JSON ──────────────────────────────────────
function copyJSON(type) {
    if (!currentPages) return;
    const btn = document.getElementById('copy_' + type);
    navigator.clipboard.writeText(currentPages[type] || '').then(() => {
        btn.textContent = '✓ Copied!'; btn.classList.add('copied');
        setTimeout(() => { btn.textContent = 'Copy JSON'; btn.classList.remove('copied'); }, 2000);
    });
}
function downloadJSON(type) {
    if (!currentPages || !currentBiz) return;
    downloadFile(currentPages[type] || '', `${slugify(currentBiz.name)}-${type}.json`);
}

// ── SEO Report ────────────────────────────────────────────────
function buildSEOReportText() {
    const b = currentBiz; const s = seoResult;
    if (!b || !s) return '';
    return `SEO REPORT — ${b.name}
Generated: ${new Date().toLocaleString()}
Tool: NAVTCC Elementor Template Generator
Created by Jawad with help of AI
============================================

BUSINESS INFO
Name    : ${b.name}
Type    : ${b.type}
City    : ${b.city}
Phone   : ${b.phone}
Email   : ${b.email}
Address : ${b.address}
Hours   : ${b.hours}
Schema  : ${b.schemaType}

META FIELDS — HOME PAGE
  Focus Keyword    : ${b.focusKeyword}
  SEO Title        : ${b.metaTitle_home}
  Meta Description : ${b.metaDesc_home}
  URL Slug         : ${b.slug_home}

META FIELDS — SERVICES PAGE
  Focus Keyword    : ${b.keywords?.[1]||b.focusKeyword}
  SEO Title        : ${b.metaTitle_services}
  Meta Description : ${b.metaDesc_services}
  URL Slug         : ${b.slug_services}

META FIELDS — CONTACT PAGE
  Focus Keyword    : ${b.keywords?.[2]||b.focusKeyword}
  SEO Title        : ${b.metaTitle_contact}
  Meta Description : ${b.metaDesc_contact}
  URL Slug         : ${b.slug_contact}

SEO SCORE: ${s.score}/100 (${s.passed}/${s.total} checks passed)
--------------------------------------------
${s.checks.map(c => `[${c.pass?'✓':'✗'}] ${c.label}${!c.pass?'\n    TIP: '+c.tip:''}`).join('\n')}

KEYWORD DENSITY
--------------------------------------------
${kwData.map(k => `${k.kw}: ${k.count}x found, ${k.density}% density [${k.status.toUpperCase()}]`).join('\n')}

IMPORT STEPS
--------------------------------------------
1. Install Elementor free plugin in WordPress
2. Pages → Add New → Edit with Elementor
3. ☰ Menu → My Templates → Import Templates
4. Upload .json file → Insert
5. Repeat for all 3 pages
6. Install Yoast SEO or RankMath → paste meta fields

LOCAL SEO CHECKLIST (Pakistan)
--------------------------------------------
[ ] Create Google My Business listing
[ ] Business name: "${b.name}"
[ ] Address: ${b.address}
[ ] Phone: ${b.phone}
[ ] Upload 5+ business photos to GMB
[ ] Get Google reviews from customers
[ ] List on: Locally.pk, PakistanDirectory.com
[ ] NAP identical: website + GMB + directories

Generated by NAVTCC SEO Tool — Created by Jawad with help of AI`;
}
function copySEOReport() {
    const report = buildSEOReportText();
    navigator.clipboard.writeText(report).then(() => {
        const btn = document.getElementById('btnCopySEO');
        btn.textContent = '✓ Copied!';
        setTimeout(() => btn.textContent = '📋 Copy Full SEO Report', 2000);
    });
}
function downloadSEOReport() {
    if (!currentBiz) return;
    downloadFile(buildSEOReportText(), `${slugify(currentBiz.name)}-SEO-Report.txt`, 'text/plain');
}

// ── ZIP download (using JSZip CDN) ───────────────────────────
async function downloadAllZip() {
    if (!currentPages || !currentBiz) return;
    const btn = document.querySelector('[onclick="downloadAllZip()"]');
    btn.textContent = '⏳ Creating ZIP...';

    // Dynamically load JSZip
    if (typeof JSZip === 'undefined') {
        await new Promise((res, rej) => {
            const s = document.createElement('script');
            s.src = 'https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js';
            s.onload = res; s.onerror = rej;
            document.head.appendChild(s);
        });
    }

    const zip  = new JSZip();
    const name = slugify(currentBiz.name);
    zip.file(`${name}-home.json`,    currentPages.home);
    zip.file(`${name}-services.json`,currentPages.service);
    zip.file(`${name}-contact.json`, currentPages.contact);
    zip.file(`${name}-SEO-Report.txt`, buildSEOReportText());

    const blob = await zip.generateAsync({ type: 'blob' });
    const url  = URL.createObjectURL(blob);
    const a    = document.createElement('a');
    a.href = url; a.download = `${name}-elementor-package.zip`; a.click();
    URL.revokeObjectURL(url);
    btn.textContent = '📦 Download All Files (.zip)';
}

// ── Init ─────────────────────────────────────────────────────
document.addEventListener('DOMContentLoaded', loadSaved);
