<!-- ============================================================
     INPUT PAGE
     ============================================================ -->
<div class="page active" id="pageInput">

    <!-- HERO -->
    <div class="hero">
        <div class="hero-badge"><span>HOME + SERVICES + CONTACT PAGES</span></div>
        <h1>Free Elementor Template Generator</h1>
        <p>Enter your business details and get 3 SEO-optimized Elementor pages with AI-written content, random unique designs, keyword analysis and Yoast/RankMath fields — completely free.</p>
        <div class="feature-pills">
            <div class="pill"><strong>✓</strong> Groq / Gemini AI</div>
            <div class="pill"><strong>✓</strong> 12 Business Templates</div>
            <div class="pill"><strong>✓</strong> SEO Learn Mode</div>
            <div class="pill"><strong>✓</strong> Random Unique Design</div>
            <div class="pill"><strong>✓</strong> 3 Elementor Pages</div>
            <div class="pill"><strong>✓</strong> Full On-Page SEO</div>
            <div class="pill"><strong>✓</strong> Yoast / RankMath Fields</div>
            <div class="pill"><strong>✓</strong> Live Preview</div>
        </div>
    </div>

    <div class="wrap">

        <!-- CLASS CODE -->
        <div class="class-code-wrap">
            <label>🔐 CLASS CODE</label>
            <input class="form-input" id="classCode" type="password"
                placeholder="Enter code given by your instructor"
                data-valid="<?= CLASS_CODE ?>"
                style="flex:1; max-width:280px;"
                oninput="saveClassCode(this.value)">
            <span id="codeStatus" style="font-size:11px; font-family:var(--font-mono);"></span>
        </div>

        <!-- STEP 1: THEME -->
        <div class="sec-label">Step 1 — Choose Design Theme</div>
        <div class="theme-grid" id="themeGrid">

            <div class="theme-card theme-corp active" data-theme="corporate" onclick="selectTheme(this,'corporate')">
                <div class="theme-check">✓</div>
                <div class="theme-emoji">🏛️</div>
                <div class="theme-name" style="color:#c9a84c">Corporate Pro</div>
                <div class="theme-desc">Navy & Gold — Law, Finance, Medical, Consulting</div>
                <div class="theme-dots">
                    <div class="theme-dot" style="background:#1a1f4e"></div>
                    <div class="theme-dot" style="background:#c9a84c"></div>
                    <div class="theme-dot" style="background:#f8f7f4"></div>
                </div>
            </div>

            <div class="theme-card theme-vib" data-theme="vibrant" onclick="selectTheme(this,'vibrant')">
                <div class="theme-check">✓</div>
                <div class="theme-emoji">⚡</div>
                <div class="theme-name" style="color:#a5b4fc">Modern Vibrant</div>
                <div class="theme-desc">Bold Gradients — Tech, Marketing, Startups, Education</div>
                <div class="theme-dots">
                    <div class="theme-dot" style="background:#6366f1"></div>
                    <div class="theme-dot" style="background:#f43f5e"></div>
                    <div class="theme-dot" style="background:#f8faff"></div>
                </div>
            </div>

            <div class="theme-card theme-warm" data-theme="warm" onclick="selectTheme(this,'warm')">
                <div class="theme-check">✓</div>
                <div class="theme-emoji">🌿</div>
                <div class="theme-name" style="color:#fbbf24">Warm Local</div>
                <div class="theme-desc">Earthy & Friendly — Restaurants, Salons, Clinics, Retail</div>
                <div class="theme-dots">
                    <div class="theme-dot" style="background:#b45309"></div>
                    <div class="theme-dot" style="background:#059669"></div>
                    <div class="theme-dot" style="background:#fffbf5"></div>
                </div>
            </div>

        </div>

        <!-- STEP 2: API KEYS -->
        <div class="sec-label">Step 2 — Add Your Free AI API Keys</div>

        <!-- PROVIDER STATUS BAR -->
        <div class="provider-status-bar" id="providerStatusBar">
            <div class="psb-title">🤖 AI Router Status — Add keys below to activate providers</div>
            <div class="psb-grid" id="psbGrid">
                <!-- Rendered by JS -->
            </div>
            <div class="psb-note">
                Smart router auto-selects best available provider. Add multiple keys for automatic failover.
            </div>
        </div>

        <div class="api-section">

            <div class="api-tabs">
                <button class="api-tab active" id="tabGroq"       onclick="switchKeyTab('groq')">
                    🚀 Groq
                </button>
                <button class="api-tab"         id="tabGemini"    onclick="switchKeyTab('gemini')">
                    🔷 Gemini
                </button>
                <button class="api-tab"         id="tabOpenrouter" onclick="switchKeyTab('openrouter')">
                    🌐 OpenRouter
                </button>
            </div>

            <!-- GROQ -->
            <div id="instructions_groq" class="api-instructions">
                Get your <strong style="color:#a5b4fc">FREE Groq API key</strong>:
                <ol>
                    <li>Open <a href="https://console.groq.com" target="_blank">console.groq.com</a></li>
                    <li>Sign up with email — no credit card needed</li>
                    <li>API Keys → Create API Key → copy it</li>
                    <li>Key starts with <code style="color:#f59e0b">gsk_</code></li>
                </ol>
                <div style="color:#10b981;font-size:11px;margin-top:6px">
                    ✓ Free · 14,400 req/day · Fastest inference · Powers both Llama 70B and 8B
                </div>
            </div>

            <!-- GEMINI -->
            <div id="instructions_gemini" class="api-instructions" style="display:none">
                Get your <strong style="color:#a5b4fc">FREE Gemini API key</strong>:
                <ol>
                    <li>Open <a href="https://aistudio.google.com" target="_blank">aistudio.google.com</a></li>
                    <li>Sign in with Google account</li>
                    <li>Get API Key → Create API Key → copy it</li>
                    <li>Key starts with <code style="color:#f59e0b">AIza</code></li>
                </ol>
                <div style="color:#10b981;font-size:11px;margin-top:6px">
                    ✓ Free · 1 Million tokens/day · Google's best fast model
                </div>
            </div>

            <!-- OPENROUTER -->
            <div id="instructions_openrouter" class="api-instructions" style="display:none">
                Get your <strong style="color:#a5b4fc">FREE OpenRouter key</strong> — access DeepSeek R1 free:
                <ol>
                    <li>Open <a href="https://openrouter.ai" target="_blank">openrouter.ai</a></li>
                    <li>Sign up free — no credit card for free models</li>
                    <li>Keys → Create Key → copy it</li>
                    <li>Key starts with <code style="color:#f59e0b">sk-or-</code></li>
                </ol>
                <div style="color:#10b981;font-size:11px;margin-top:6px">
                    ✓ Free · DeepSeek R1 + Gemini Flash · Best content quality · 1 key = 20+ models
                </div>
            </div>

            <!-- KEY INPUT -->
            <div class="api-key-wrap">
                <input class="form-input" id="apiKeyGroq" type="password"
                    placeholder="Groq key: gsk_..."
                    oninput="saveProviderKey('groq', this.value)"
                    style="display:block">
                <input class="form-input" id="apiKeyGemini" type="password"
                    placeholder="Gemini key: AIza..."
                    oninput="saveProviderKey('gemini', this.value)"
                    style="display:none">
                <input class="form-input" id="apiKeyOpenrouter" type="password"
                    placeholder="OpenRouter key: sk-or-..."
                    oninput="saveProviderKey('openrouter', this.value)"
                    style="display:none">
                <button class="api-key-toggle" onclick="toggleKeyVisibility()">Show</button>
            </div>

            <div class="api-saved-note" id="keySavedNote" style="display:none">
                ✓ Key saved in your browser
            </div>

            <div style="margin-top:8px;font-size:10px;color:var(--muted);font-family:var(--font-mono)">
                🔒 Keys stored only in YOUR browser localStorage — never sent to any server except the AI provider directly.
            </div>

        </div>

        <!-- STEP 3: BUSINESS TYPE TEMPLATES -->
        <div class="sec-label">Step 3 — Quick Start: Choose Business Type</div>
        <div class="biz-type-grid" id="bizTypeGrid">

            <div class="biz-type-card" onclick="loadBizTemplate('dental')">
                <div class="biz-type-icon">🦷</div>
                <div class="biz-type-name">Dental Clinic</div>
            </div>
            <div class="biz-type-card" onclick="loadBizTemplate('restaurant')">
                <div class="biz-type-icon">🍽️</div>
                <div class="biz-type-name">Restaurant</div>
            </div>
            <div class="biz-type-card" onclick="loadBizTemplate('salon')">
                <div class="biz-type-icon">💇</div>
                <div class="biz-type-name">Beauty Salon</div>
            </div>
            <div class="biz-type-card" onclick="loadBizTemplate('law')">
                <div class="biz-type-icon">⚖️</div>
                <div class="biz-type-name">Law Firm</div>
            </div>
            <div class="biz-type-card" onclick="loadBizTemplate('gym')">
                <div class="biz-type-icon">💪</div>
                <div class="biz-type-name">Gym / Fitness</div>
            </div>
            <div class="biz-type-card" onclick="loadBizTemplate('school')">
                <div class="biz-type-icon">🏫</div>
                <div class="biz-type-name">School / Academy</div>
            </div>
            <div class="biz-type-card" onclick="loadBizTemplate('hospital')">
                <div class="biz-type-icon">🏥</div>
                <div class="biz-type-name">Clinic / Hospital</div>
            </div>
            <div class="biz-type-card" onclick="loadBizTemplate('realestate')">
                <div class="biz-type-icon">🏠</div>
                <div class="biz-type-name">Real Estate</div>
            </div>
            <div class="biz-type-card" onclick="loadBizTemplate('hvac')">
                <div class="biz-type-icon">❄️</div>
                <div class="biz-type-name">HVAC Services</div>
            </div>
            <div class="biz-type-card" onclick="loadBizTemplate('hotel')">
                <div class="biz-type-icon">🏨</div>
                <div class="biz-type-name">Hotel / Guest House</div>
            </div>
            <div class="biz-type-card" onclick="loadBizTemplate('pharmacy')">
                <div class="biz-type-icon">💊</div>
                <div class="biz-type-name">Pharmacy</div>
            </div>
            <div class="biz-type-card" onclick="loadBizTemplate('transport')">
                <div class="biz-type-icon">🚗</div>
                <div class="biz-type-name">Transport / Rent a Car</div>
            </div>

        </div>
        <div class="info-box" style="margin-bottom:20px">
            💡 Click any business type above to auto-fill example data — then customize with your client's real info.
        </div>

        <!-- STEP 4: BUSINESS DETAILS -->
        <div class="sec-label">Step 4 — Business Details</div>
        <div class="form-card">

            <div class="form-card-header">
                <span style="font-size:13px; color:var(--muted)">Fill in your client's business information</span>
                <div style="display:flex;gap:8px;align-items:center;flex-wrap:wrap">
                    <button class="btn-secondary" id="btnLearnMode" onclick="toggleLearnMode()" title="Show SEO tips for each field">
                        💡 SEO Learn Mode: OFF
                    </button>
                    <button class="btn-secondary" onclick="loadExample()">📋 Load Example</button>
                </div>
            </div>

            <!-- SEO Learn Mode Banner -->
            <div id="learnModeBanner" style="display:none;background:rgba(99,102,241,0.08);border:1px solid rgba(99,102,241,0.25);border-radius:8px;padding:10px 14px;margin-bottom:16px;font-size:12px;color:#a5b4fc;font-family:var(--font-mono)">
                📚 <strong>SEO Learn Mode ON</strong> — Each field now shows WHY it matters for SEO. Read the tips to understand the strategy behind each decision.
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Business Name *</label>
                    <div class="seo-tip" id="tip-bizName">📌 <strong>Brand Signal:</strong> Google uses business name for brand searches. Keep it consistent across your website, Google My Business, and all directories — this is called NAP consistency.</div>
                    <input class="form-input" id="bizName" placeholder="e.g. Al-Noor Dental Clinic">
                </div>
                <div class="form-group">
                    <label class="form-label">Business Type *</label>
                    <div class="seo-tip" id="tip-bizType">📌 <strong>Schema Type:</strong> This determines your Schema.org markup. Google uses schema to show rich results — star ratings, hours, address — directly in search results.</div>
                    <input class="form-input" id="bizType" placeholder="e.g. Dental Clinic, Restaurant, Salon">
                </div>
            </div>

            <div class="form-group" style="margin-bottom:14px">
                <label class="form-label">Services * <span class="hint">(comma separated)</span></label>
                <div class="seo-tip" id="tip-bizServices">📌 <strong>Keyword Silos:</strong> Each service becomes its own section with keyword-rich content. More services = more long-tail keyword opportunities. Google ranks pages, not websites — each service targets different search queries.</div>
                <input class="form-input" id="bizServices"
                    placeholder="e.g. Teeth Whitening, Braces, Root Canal, Dental Implants, Checkup">
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Target City *</label>
                    <div class="seo-tip" id="tip-bizCity">📌 <strong>Local SEO:</strong> City name goes into H1, meta title, and URL. This is how Google understands your geographic target. "dentist lahore" gets 10x more local clicks than just "dentist".</div>
                    <input class="form-input" id="bizCity" placeholder="e.g. Lahore">
                </div>
                <div class="form-group">
                    <label class="form-label">Tagline *</label>
                    <div class="seo-tip" id="tip-bizTagline">📌 <strong>Value Proposition:</strong> Appears in meta description and hero section. A clear tagline improves CTR (Click Through Rate) from Google search results — people decide whether to click based on this.</div>
                    <input class="form-input" id="bizTagline" placeholder="e.g. Your Smile, Our Priority">
                </div>
            </div>

            <div class="form-group" style="margin-bottom:14px">
                <label class="form-label">Target Keywords * <span class="hint">(comma separated, 3–5 keywords)</span></label>
                <div class="seo-tip" id="tip-bizKeywords">📌 <strong>Keyword Strategy:</strong> First keyword = Focus Keyword (goes in H1 + meta title). Others = secondary keywords (used in H2s and body text). Always include city name. Format: "service + city" e.g. "best dentist lahore".</div>
                <input class="form-input" id="bizKeywords"
                    placeholder="e.g. best dentist lahore, dental clinic lahore, teeth whitening lahore">
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Contact Phone *</label>
                    <div class="seo-tip" id="tip-bizPhone">📌 <strong>NAP + Schema:</strong> Phone number goes into LocalBusiness schema markup. Google uses this for Knowledge Panel and Google Maps. Must match exactly across all platforms.</div>
                    <input class="form-input" id="bizPhone" placeholder="+92-300-1234567">
                </div>
                <div class="form-group">
                    <label class="form-label">Contact Email *</label>
                    <div class="seo-tip" id="tip-bizEmail">📌 <strong>Trust Signal:</strong> Email in schema markup and contact page increases Google's trust score. Businesses with complete contact info rank better in local search.</div>
                    <input class="form-input" id="bizEmail" placeholder="info@yourbusiness.com">
                </div>
            </div>

            <div class="form-group" style="margin-bottom:14px">
                <label class="form-label">Full Address *</label>
                <div class="seo-tip" id="tip-bizAddress">📌 <strong>Local Pack:</strong> Complete address is required to appear in Google Maps "Local Pack" (the 3 map results at top of search). Street address + area + city = maximum local ranking power.</div>
                <input class="form-input" id="bizAddress"
                    placeholder="e.g. 123 Main Boulevard, Gulberg III, Lahore">
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Working Hours <span class="hint">(optional)</span></label>
                    <div class="seo-tip" id="tip-bizHours">📌 <strong>Opening Hours Schema:</strong> Hours appear in Google search results directly. "Open now" indicator increases click rate by 20-30%. Also required for Google My Business verification.</div>
                    <input class="form-input" id="bizHours" placeholder="e.g. Mon-Sat 9AM-7PM">
                </div>
                <div class="form-group">
                    <label class="form-label">Primary Color <span class="hint">(optional)</span></label>
                    <div class="seo-tip" id="tip-bizColor">📌 <strong>Brand Consistency:</strong> Consistent color across website, social media, and GMB listing builds brand recognition. Users who recognize your brand are more likely to click your search result.</div>
                    <div style="display:flex; gap:8px; align-items:center">
                        <input type="color" id="bizColor" value="#6366f1"
                            style="width:44px;height:38px;border:1px solid var(--border);border-radius:6px;background:transparent;cursor:pointer;padding:2px"
                            oninput="document.getElementById('bizColorHex').value=this.value">
                        <input class="form-input" id="bizColorHex" placeholder="#6366f1" style="flex:1"
                            oninput="syncColor(this.value)">
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label class="form-label">About Your Business <span class="hint">(1–2 sentences, optional)</span></label>
                <div class="seo-tip" id="tip-bizAbout">📌 <strong>E-E-A-T Signal:</strong> Google's ranking factor: Experience, Expertise, Authority, Trust. Mentioning years in business, team size, certifications, or awards tells Google this is a real, trusted business.</div>
                <textarea class="form-input" id="bizAbout"
                    placeholder="e.g. Al-Noor Dental Clinic has been serving Lahore since 2010 with a team of experienced dentists and modern equipment..."></textarea>
            </div>

        </div>

        <!-- ERROR -->
        <div class="error-box" id="errorBox"></div>
        <div class="loading-bar" id="loadingBar"></div>
        <div class="gen-status" id="genStatus"></div>

        <!-- GENERATE -->
        <button class="btn-gen" id="btnGen" onclick="generate()">
            ⚡ Generate 3 Elementor Pages with AI
        </button>

        <div class="info-box" style="margin-top:14px; text-align:center">
            💡 No API key? The tool still works with free JS templates — just click Generate without a key.
        </div>

    </div><!-- /wrap -->
</div><!-- /pageInput -->
